/*
 *
 *  Copyright (C) 2010-2011 Amr Thabet <amr.thabet@student.alx.edu.eg>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to Amr Thabet 
 *  amr.thabet@student.alx.edu.eg
 *
 */
typedef unsigned long dword;
#define EXP_IGNORE 0
#define EXP_ERROR  -1
#if BUILDING_DLL
#include "hde28c\hde32.h"
#include "disasm\disassembler.h"
#include "apis\apis.h"
#include "emu\emu.h"
#include "seh.h"
#include "os\os.h"
#endif
//------
#include "tib.h"
#include "pe.h"
#include <iostream.h>
#include <fstream.h>
#include <string.h>
//Flags
#define EFLG_OF (1<<11)
#define EFLG_SF (1<<7)
#define EFLG_ZF (1<<6)
#define EFLG_AF (1<<4)
#define EFLG_PF (1<<2)
#define EFLG_CF (1<<0)
#define EFLG_SYS (0x202)
//-------
//CUSTOM FLAGS SETTING
#define UPDATEFLAGS_CMP 1
#define UPDATEFLAGS_ADD 2
#define UPDATEFLAGS_SUB 3
//------
//MEMORY FLAGS
#define MEM_READWRITE 0
#define MEM_READONLY 1
#define MEM_IMAGEBASE 2             //mixing readonly & readwrite so it needs to be check
#define MEM_DLLBASE 3
#define MEM_VIRTUALPROTECT 4
//--------
//EXCEPTIONS

#define EXP_INVALIDPOINTER 1
#define EXP_WRITEACCESS_DENIED 2
#define EXP_INVALID_OPCODE 3
#define EXP_DIVID_BY_ZERO 4
#define EXP_INVALID_INSTRUCTION 5
#define EXP_DIV_OVERFLOW 6
#define EXP_BREAKPOINT 7

#define ERROR_FILENAME 8
using namespace std;
typedef unsigned long dword;

#if BUILDING_DLL
# define DLLIMPORT __declspec (dllexport)
#else /* Not BUILDING_DLL */
# define DLLIMPORT __declspec (dllimport)
#endif /* Not BUILDING_DLL */


class  DLLIMPORT Process;
class  DLLIMPORT Thread;
class  DLLIMPORT Log;
class Thread;
struct ins_disasm;
struct bytes;
struct FLAGTABLE;
struct hde32s;
struct DLL;
struct API;
//==================================
//APIs
struct DLL{
       char* name;
       dword imagebase;
       dword size;
       dword vAddr;
};
struct API{
       char* name;
       DLL*  lib;
       dword args;
       dword addr;
       int (*emu_func)(Thread*,dword*);
};
//===================================
//Debugger 

#define NO_OF_BP_FUNCTIONS 100
#define BP_RUN 0
#define BP_PAUSE 1
#define BP_REMOVE 2
struct BPFunction{ 
           int params;
           dword dbg_func;
           string name;
           int flags;
};

//===================================
struct FLAGTABLE{ 
           int opcode;
           int reg;
           int (*emu_func)(Thread&,ins_disasm*);
           string mnemonics;
           int flags;
           };
struct Exception{
       int Type;
       char* error;
       dword ptr;
       };

struct EnviromentVariables{
       dword date;
       dword time;
       dword kernel32;
       dword ntdll;
       dword user32;
       char* dllspath;
       dword MaxIterations;
       };
class DLLIMPORT System{
      public:
          int dis_entries;
          FLAGTABLE FlagTable[512*7];
          DLL DLLs[3];
          API APITable[100];
          int dll_entries;
          int api_entries;
          EnviromentVariables enVars;
          System(EnviromentVariables* v);
          // Assembler
          bytes* assembl(string instruction);
          ins_disasm* disasm(ins_disasm* bIns,char* ins_bytes);
          ins_disasm* disasm(ins_disasm* bIns,char* ins_bytes,string& str);
          int define_opcodes(int opcode,int reg,int (*emu_func)(Thread&,ins_disasm*),string mnemonics,int flags);
          int opcodes_init();
          int init_vars(EnviromentVariables* v);
          //APIs
          int define_dll(char* name,char* path,dword vAddr);
          int define_api(char* name,DLL* lib,dword args,int (*emu_func)(Thread*,dword*));
          bool IsApiCall(Thread&,ins_disasm*&);
          int CallToAPI(Thread*,ins_disasm*);
          unsigned long GetAPI(char* func,unsigned long dll);
          char* GetAPIbyAddress(unsigned long ptr,unsigned long dll);
          unsigned long GetDllBase(char*);
          unsigned long GetDllIndex(char* s);
          char* GetTiggeredAPI(Thread& thread);
          int init_apis(char* path);
};
class DLLIMPORT Debugger{
      struct {
             dword ptr;
             int state;
      } bp[1000];
      BPFunction funcs[NO_OF_BP_FUNCTIONS];
      int func_entries;
      dword nbp;
      dword parser(string);
      Process* process;
      string lasterror;
      public:
             bool TestBp(int num,Thread& thread,ins_disasm* ins);
             bool TestBp(Thread& thread,ins_disasm* ins);
             int AddBp(string s);
             void RemoveBp(int index);
             void PauseBp(int index);
             void ActivateBp(int index);
             int define_func(string name,int params,dword func,int flags);
             int init_funcs();
             Debugger(Process&);
             string GetLastError();
      private: 
            //expressions solvers
            dword boolexp(string&);
            dword boolexp2(string&);
            dword mathexp(string&);
            dword mulexp(string&);
            dword getnum(string&);
            //math
            dword domul(string&);
            dword dodiv(string&);
            dword doand(string&);
            dword domod(string&);
            dword doadd(string&);
            dword dosub(string&);
            dword door(string&);
            dword doxor(string&);
            dword donot(string&);
            dword doneg(string&);
            //boolean
            dword dogreaterequal(string&);
            dword dolowerequal(string&);
            dword doequal(string&);
            dword donotequal(string&);
            dword dogreater(string&);
            dword dolower(string&);
            dword doandbool(string&);
            dword doorbool(string&);
            //Variables
            dword doreg32(int);
            //functions
            dword callfunc(string&);
            dword strfunc(string&);
            //---
            void add_to_buffer(bytes*);
      };
class DLLIMPORT VirtualMemory{
      struct vMem{
             dword vmem;
             dword rmem;
             dword size;
             dword flags;
             };    
      struct cMem{          //the changes in the memory during the emulation
             dword ptr;     //here the pointer to the virtual memory not the real pointer
             dword size;
             dword flags;
             };
      dword last_accessed;
      dword last_modified;
      public:
             dword CommittedPages;
             int vmem_length;
             int cmem_length;
             vMem** vmem;
             cMem** cmem;
             VirtualMemory ();
             dword get_virtual_pointer(dword ptr);
             dword* read_virtual_mem(dword ptr);
             dword write_virtual_mem(dword ptr,dword size,char* buff); //ptr , size, buff -return-> valid or not
             bool get_memory_flags(dword ptr);
             dword set_memory_flags(dword ptr,int size);
             dword get_last_accessed();
             dword get_last_modified();
             dword add_pointer(dword rptr,dword vptr,dword size,int=MEM_READWRITE);
             dword delete_pointer(dword ptr);
             bool check_writeaccess(dword ptr,dword imagebase);
      };

class DLLIMPORT Stack{
      Thread* thread;
      public:
             dword stackTop;
             dword stackBottom;
             Stack(Thread&);
             int push(dword);
             int pop();
      };
class DLLIMPORT Thread{
      TIB* tib;
      TEB* teb;
      dword fs;
      bool seh_enable;
      public:
             Process* process;
             Log* log;
             Stack* stack;
             VirtualMemory* mem;
             dword EFlags;
             dword Eip;
             dword Exx[7];
             dword GetFS();
             Process* GetProcess();
             int updateflags(dword,dword,dword,int);
             void generateException(dword code);
             void doException(dword rec);
             void sehReturn();
             Thread(dword,Process&);
             Thread();
             void CreateTEB();
      friend class Process;
      };

class DLLIMPORT Process {
      private:
              System* sys;
              Thread* threads[100];
              int nthreads;
              int error;
              int Imagebase;
              int ImportTableFixup(dword);
              int APIsFixup(dword,image_import_descriptor*,dword);
              void CreatePEB();
              ins_disasm* ins;
              bool TiggeredBreakpoint;
              dword MaxIterations;
      public:
             PEB* peb;
             Debugger* debugger;
             VirtualMemory* SharedMem;
             System* getsystem();
             int emulate();
             int emulatecommand(int);
             int emulatecommand();
             int CreateThread(dword);
             Thread* GetThread(int);
             int GetNumOfThreads(){return nthreads;};
             ins_disasm* GetLastIns();
             dword GetImagebase();
             dword SkipIt();
             Process (System* sys,string filename);
             ~Process();
      };
class DLLIMPORT Log {
      private:
              dword log[10];
              int cur;
      public:
             Log(dword);
             void addlog(dword);
             dword getlog(int);
      };
//strings
int compare_array(string,string[],int);
int compare_array(string,string[],int,int);
string DLLIMPORT to_lower_case(string);
string DLLIMPORT trim(string); 
int DLLIMPORT imm_to_dec(string);

//important functions

int call_to_func(dword,dword,dword);     
dword DLLIMPORT PELoader(string filename);
dword DLLIMPORT PEDump(dword Eip,Process* c,string filename);

//==========================================
// Hacker Disassmbler Engine

#include <stdint.h>

#define F_MODRM         0x00000001
#define F_SIB           0x00000002
#define F_IMM8          0x00000004
#define F_IMM16         0x00000008
#define F_IMM32         0x00000010
#define F_DISP8         0x00000020
#define F_DISP16        0x00000040
#define F_DISP32        0x00000080
#define F_RELATIVE      0x00000100
#define F_2IMM16        0x00000800
#define F_ERROR         0x00001000
#define F_ERROR_OPCODE  0x00002000
#define F_ERROR_LENGTH  0x00004000
#define F_ERROR_LOCK    0x00008000
#define F_ERROR_OPERAND 0x00010000
#define F_PREFIX_REPNZ  0x01000000
#define F_PREFIX_REPX   0x02000000
#define F_PREFIX_REP    0x03000000
#define F_PREFIX_66     0x04000000
#define F_PREFIX_67     0x08000000
#define F_PREFIX_LOCK   0x10000000
#define F_PREFIX_SEG    0x20000000
#define F_PREFIX_ANY    0x3f000000

#define PREFIX_SEGMENT_CS   0x2e
#define PREFIX_SEGMENT_SS   0x36
#define PREFIX_SEGMENT_DS   0x3e
#define PREFIX_SEGMENT_ES   0x26
#define PREFIX_SEGMENT_FS   0x64
#define PREFIX_SEGMENT_GS   0x65
#define PREFIX_LOCK         0xf0
#define PREFIX_REPNZ        0xf2
#define PREFIX_REPX         0xf3
#define PREFIX_OPERAND_SIZE 0x66
#define PREFIX_ADDRESS_SIZE 0x67

#pragma pack(push,1)

typedef struct hde32s{
    uint8_t len;
    uint8_t p_rep;
    uint8_t p_lock;
    uint8_t p_seg;
    uint8_t p_66;
    uint8_t p_67;
    uint8_t opcode;
    uint8_t opcode2;
    uint8_t modrm;
    uint8_t modrm_mod;
    uint8_t modrm_reg;
    uint8_t modrm_rm;
    uint8_t sib;
    uint8_t sib_scale;
    uint8_t sib_index;
    uint8_t sib_base;
    union {
        uint8_t imm8;
        uint16_t imm16;
        uint32_t imm32;
    } imm;
    union {
        uint8_t disp8;
        uint16_t disp16;
        uint32_t disp32;
    } disp;
    uint32_t flags;
};
#pragma pack(pop)
//==============================
//Disassembler

#define OP_0F      0x00800000        //for 2 bytes opcode
#define OP_SRC8    0x01000000        //for movzx
#define OP_SRC16   0x02000000        //for movzx
#define OP_ANY     0x04000000        //no source and no destination
//Assembler states
#define NO_SRCDEST  0x80000000         // no opcodes     
#define DEST_REG    0x00000100
#define DEST_RM     0x00000200
#define DEST_IMM    0x00000400        //IMM8 or IMM32 
#define DEST_BITS32 0x00000800
#define DEST_BITS16 0x00001000
#define DEST_BITS8  0x00002000

#define SRC_REG     0x00004000
#define SRC_NOSRC   0x00008000
#define SRC_RM      0x00010000
#define SRC_IMM     0x00020000        //IMM8 or IMM32 
#define SRC_BITS32  0x00040000
#define SRC_BITS16  0x00001000        //the same as  DEST_BITS16
#define SRC_BITS8   0x00080000

#define RM_SIB      0x00100000       // it will not differ dest or src because it should be one rm
#define INS_UNDEFINED 0x00200000    //for the disasembler only
#define INS_INVALID 0x00400000       //invalid instruction (returned by hde32) 
#define MOVXZ_SRC16 0x00800000
#define MOVXZ_SRC8  0x01000000
#define EIP_UPDATED 0x02000000
#define API_CALL    0x04000000
//ModRM states
#define RM_REG      0x00000001
#define RM_DISP8    0x00000002
#define RM_DISP16   0x00000004
#define RM_DISP32   0x00000008
#define RM_DISP     0x00000010
#define RM_MUL2     0x00000020
#define RM_MUL4     0x00000040
#define RM_MUL8     0x00000080
#define RM_ADDR16   0x00000100

struct ins_disasm{
          hde32s hde;
          int entry;                 //the index of this opcode in the FlagTable
          string* opcode;
          int ndest;
          int nsrc;
          int other;      //used for mul to save the imm and used for any call to api to save the index of the api(it's num in APITable)
          struct {
                 int length;
                 int items[3];
                 int flags[3];
          } modrm;
          int (*emu_func)(Thread&,ins_disasm*);
          int flags;
    };
  //assembler & disassembler
   struct bytes {
           int length;
           char s[16];
   };

/*
#ifdef WIN32
  #ifdef EXPORT_CLASS_FOO
    #define CLASS_FOO __declspec(dllexport)    //while building the dll
  #else
    #define CLASS_FOO __declspec(dllimport)    //while use the dll
  #endif
#else
  #define CLASS_FOO
#endif

class CLASS_Foo foo
{ ... };
//*/
